/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "test_common.h"

int main(void)
{
  mx_endpoint_t ep;
  mx_endpoint_addr_t addr;
  char buff1[80];
  char buff2[80];
  mx_segment_t seg1;
  mx_segment_t seg2;
  mx_request_t req1;
  mx_request_t req2;
  mx_status_t status;
  mx_return_t ret;
  uint32_t handle;
  uint32_t result;

  ret = mx_init();
  insist(ret == MX_SUCCESS);
  ret = mx_open_endpoint(MX_ANY_NIC, MX_ANY_ENDPOINT, 0, NULL, 0, &ep);
  insist(ret == MX_SUCCESS);
  ret = mx_get_endpoint_addr(ep, &addr);
  insist(ret == MX_SUCCESS);

  seg1.segment_ptr = buff1;
  seg1.segment_length = 80;
  seg2.segment_ptr = buff2;
  seg2.segment_length = 80;

  ret = mx_create_rdma_window(ep, &seg1, 1,
			      MX_RDMA_READ|MX_RDMA_WRITE, &handle);
  insist(ret == MX_SUCCESS);
  strcpy(buff1, "hello");
  strcpy(buff2, "junk");
  ret = mx_rdma_read(ep, &seg2, 1, addr, handle, 0, NULL, &req1);
  insist(ret == MX_SUCCESS);
  ret = mx_wait(ep, &req1, 1000, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));
  printf("%s\n", buff2);

  strcpy(buff2, "goodbye");
  strcpy(buff1, "more junk\n");
  ret = mx_rdma_write(ep, &seg2, 1, addr, handle, 0, NULL, &req2);
  insist(ret == MX_SUCCESS);
  ret = mx_wait(ep, &req2, 1000, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));
  printf("%s\n", buff1);

  mx_finalize();
  return 0;
}
